unit ViewPixCreateImmediateCharge;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, BodyChargesClass, XSuperObject, System.UITypes;

type
  TViewCreateImmediateCharge = class(TForm)
    GroupBox3: TGroupBox;
    btnConfirmRequest: TButton;
    btnCancelRequest: TButton;
    gbDevedor: TGroupBox;
    txtName: TEdit;
    txtCpf: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    Label4: TLabel;
    txtExpiration: TEdit;
    gbValor: TGroupBox;
    Label3: TLabel;
    txtValue: TEdit;
    GroupBox2: TGroupBox;
    txtKey: TEdit;
    GroupBox4: TGroupBox;
    txtPayerRequest: TEdit;
    procedure btnCancelRequestClick(Sender: TObject);
    procedure btnConfirmRequestClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    function GetBody : String;
  public
    property Body: String read GetBody;
    procedure ClearRequestfields;
  end;

implementation

{$R *.dfm}

procedure TViewCreateImmediateCharge.btnCancelRequestClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TViewCreateImmediateCharge.btnConfirmRequestClick(Sender: TObject);
begin

  if ((txtCpf.Text = EmptyStr) and (txtName.Text <> EmptyStr)) then
  begin
    MessageDlg('Necessrio voc preencher todos os dados do Devedor', TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOK], 0);
    if txtCpf.CanFocus then
      txtCpf.SetFocus;
  end
  else if ((txtCpf.Text <> EmptyStr) and (txtName.Text = EmptyStr)) then
  begin
    MessageDlg('Necessrio voc preencher todos os dados do Devedor', TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOK], 0);
    if txtName.CanFocus then
      txtName.SetFocus;
  end
  else if txtExpiration.Text = EmptyStr then
  begin
    MessageDlg('Necessrio informar um tempo para a cobrana', TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOK], 0);
    if txtExpiration.CanFocus then
      txtExpiration.SetFocus;
    abort;
  end
  else if txtValue.Text = EmptyStr then
  begin
    MessageDlg('Necessrio informar um valor para a cobrana', TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOK], 0);
    if txtValue.CanFocus then
      txtValue.SetFocus;
    abort;
  end
  else if txtKey.Text = EmptyStr then
  begin
    MessageDlg('A chave no pode ser vazia', TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOK], 0);
    if txtKey.CanFocus then
      txtKey.SetFocus;
    abort;
  end
  else
    ModalResult := mrOk;

end;

procedure TViewCreateImmediateCharge.FormCreate(Sender: TObject);
begin
  Self.Position := poScreenCenter;
end;

function TViewCreateImmediateCharge.GetBody: String;
var
  ClassPixCreate     : TBodyCobClass;
  FCalendar          : TCalendar;
  FDebtor            : TDebtor;
  FValue             : TValue;
  BodyRequest        : ISuperObject;
begin

  ClassPixCreate := TBodyCobClass.Create;

  FCalendar.expiration := StrToInt(txtExpiration.Text);
  ClassPixCreate.Calendar := FCalendar;

  FDebtor.cpf := txtCpf.Text;
  FDebtor.name := txtName.Text;
  ClassPixCreate.Debtor := FDebtor;

  FValue.original := txtValue.Text;
  ClassPixCreate.Value := FValue;

  ClassPixCreate.Key := txtKey.Text;
  ClassPixCreate.PayerRequest := txtPayerRequest.Text;

  BodyRequest := SO(ClassPixCreate.AsJSON(False, False));

  if (ClassPixCreate.Debtor.cpf = EmptyStr) or (ClassPixCreate.Debtor.name = EmptyStr) then
    BodyRequest.Remove('devedor');

  if ClassPixCreate.PayerRequest = EmptyStr then
    BodyRequest.Remove('solicitacaoPagador');

  BodyRequest.Remove('status');
  BodyRequest.Remove('infoAdicionais');

  Result := BodyRequest.AsJSON;
end;


procedure TViewCreateImmediateCharge.ClearRequestfields;
begin
  txtExpiration.Text := '3600';
  txtName.Text := '';
  txtCpf.Text := '';
  txtValue.Text := '';
  txtKey.Text := '';
  txtPayerRequest.Text := '';
end;

end.
